<?php

namespace Snapfile\Entities;

use Illuminate\Database\Eloquent\Model;

class ProfileType extends Model 
{

    protected $table = 'profile_types';
    public $timestamps = true;
    protected $fillable = array('name', 'allow_multiple');
    protected $visible = array('name', 'allow_multiple');

    public function fields()
    {
        return $this->hasMany('ProfileField', 'profile_type_id');
    }

    public function serviceTypes()
    {
        return $this->hasMany('Snapfile\Entities\ServiceType', 'profile_type_id');
    }

    public function profiles()
    {
        return $this->hasMany('Profile', 'profile_type_id');
    }

}